// 16 Aug 2002: Added function ShowHideCell() and getIEVersion().
//  2 Aug 2002: Added function LogoffUser().
// 16 Jul 2002: Modified function PopulateSelect() to be Netscape compliant, added getObj(), getBrowser()
// 09 Jul 2002: Modified function PopulateSelect() to accept value string, added GetUserName()
// 07 Apr 2002: Added function StrTokIdx().


// Function to log off user for content edit.
// Returns: True if user logged on 
function LogoffUser() {
	var bRet = false;
	var sUserName = GetUserName();
	if(sUserName.length > 0)
		{
		DeleteCookie(svnLogon);
		bRet = true;
		}
	return bRet;
}

// Function to get logged on user name.
// Returns: User name, blank string if no user.
function GetUserName() {
	return ce_GetUserName(); // ce_header.js
}

// Function to populate a HTML select object.
// Parameter 1: oSelect - SELECT object.
// Parameter 2: sStr    - Comma delimited string (eg "100,200,300") or ("100?1,200?2,300?3")
// Returns: Number of items in select list.
function PopulateSelect(oSelect, sList) {
	//var sList = "100,200,300,400";
	oSelect.style.visibility="hidden";
	var n = 0, i = 0, sItem,nIdxSel=-1;
	for(var j = oSelect.length - 1; j >= 0 ; --j)
		oSelect.remove(j);
	while((sItem = StrTokIdx(sList,",",i++)) != null)
		{
		var oOption = document.createElement("OPTION");
		if(sItem.charAt(0) == "*")
			{
			oOption.selected = true;
			nIdxSel = n;
			sItem = sItem.substr(1);
			}
		var sValue = StrTokIdx(sItem,"?",1);
		if(sValue != null)
			{
			oOption.text = StrTokIdx(sItem,"?",0);
			oOption.value= sValue;
			}
		else
			{
			oOption.text = sItem;
			//oOption.value=i.toString();
			}
//		oSelect.options.add[oOption];
		oSelect.options[n] = oOption;
		++n;
		}
	if(nIdxSel >= 0)
		oSelect.options[nIdxSel].selected = true;
	oSelect.style.visibility="visible";
	return n;
	}
	
// Function to return token specified by index from string separated by delimiters.
// Emulates C strtok() function.
// Parameter 1: str    - String to return token from (eg "100,200,300")
// Parameter 2: sDelim - Delimiter (eg ",")
// Parameter 3: nIndex - Index of token required starting at 0
// Returns: String token. null when index exceeds number of tokens.
function StrTokIdx(str, sDelim, nIndex) {
	str = new String(str);
	var sOut = null, nIdx1, nIdx2 = 0, nIdx3 = 0;
	var nLenTok = sDelim.length;
	for(var i = 0; nIdx2 >= 0 && i <= nIndex; ++i)
		{
		nIdx1 = nIdx3;
		nIdx2 = str.indexOf(sDelim, nIdx1);
		nIdx3 = nIdx2 + nLenTok;
		}
	if((i - 1) == nIndex)
		{
		if(nIdx2 == -1)
			sOut = str.substr(nIdx1);
		else
			sOut = str.substring(nIdx1,nIdx2);
		}
	return sOut;
}

// Functions to trim strings
function Ltrim(s, c) {
	var c1 = (c) ? c : " ";
	var len = c1.length;
	for(i = 0; i < s.length; ++i)
		if(s.substr(i,len) != c1)
			break;
	return s.substr(i);
}

function Rtrim(s, c) {
	var c1 = (c) ? c : " ";
	var len = c1.length;
	for(i = s.length - 1; i >= 0; --i)
		if(s.substr(i,len) != c1)
			break;
	return s.substr(0,i + 1);
}

function Trim(s, c) {
	return Ltrim(Rtrim(s, c), c);
}

// File path name functions that do not need client file system object support
function Getfname(path) { //v3.0
	var fname;
	var i = path.lastIndexOf("/");
	if(i >= 0)
		fname = path.substr(i + 1);
	else
		{
		i = path.lastIndexOf("\\");
		if(i >= 0)
			fname = path.substr(i + 1);
		else
			fname = path
		}
	return fname;
}

function Getfext(path) { //v3.0
	var fext;
	var fname = Getfname(path);
	var i = fname.lastIndexOf(".");
	if(i >= 0)
		fext = fname.substr(i);//i+1
	else
		fext = "";
	return fext;
}

function Getpname(path) { //v3.0
	var pname;
	var i = path.lastIndexOf("/");
	if(i >= 0)
		pname = path.substr(0,i);
	else
		{
		i = path.lastIndexOf("\\");
		if(i >= 0)
			pname = path.substr(0,i);
		else
			pname = path
		}
	return pname;
}

function GetFolderName(path) { //v3.0
	var pathout = path;
	var sHttp = "http://";
	var i = path.indexOf(sHttp);
	if(i >= 0)
		{
		i = path.indexOf("/",sHttp.length);
		if(i >= 0 && path.length > (i + 1))
			{
			var s = Getfext(path);
			if(s.length > 0)
				pathout = Getpname(path)
			}
		}
	
	return pathout;
}

// Locates and returns path (folder) component of a file name
function FindPath(path) {
	var sRet = null;
	var sPath = path.toString();
	sPath = Trim(sPath);
	if(Getfext(sPath) == "")
		sRet = sPath;
	else
		sRet = Getpname(sPath);
	return sRet;
}

// Returns path if path appears to be a file name. Null if a folder
function IsLikeFileName(path) {
	var sRet = null;
	var sPath = path.toString();
	sPath = Trim(sPath);
	if(sPath.length > 0 && Getpname(sPath) != path && Getfext(sPath) != "")
		sRet = sPath;
	return sRet;
}

function ConsAbsPath(path) { //v3.0
	var path2 = path.toLowerCase();
	var sHttp = "http://";
	var i = path2.indexOf(sHttp);
	var AbsPath;
	if(i >= 0)
		AbsPath = path2.substr(i);
	else
		{
		relpath = Ltrim(path2,"./");
		relpath = Ltrim(relpath,"/");
		relpath = Ltrim(relpath,".");
		Homepath = Rtrim(HomepathURL,"/");
		AbsPath = Homepath + "/" + relpath;
		}		
	return AbsPath;
}

// Function to remove image object from document.
// Parameter 1: Image object.
function RemoveImage(oImg) {
	if(navigator.appName == "Netscape")
		oImg.style.display="none";		 // "online"
		//oImg.style.visibility="hidden"; // "visible"
	else
		oImg.parentNode.removeNode(true);
}

// Function to return document object.
// Parameter 1: object id.
// Returns: 1=IE, 2=NS6, 3=NS4, null=unknown.
function getObj(n) {
	var x; 
	switch(getBrowser())
		{
		case 1: x = document.all[n]; break;
		case 2: x = document.getElementById(n); break;
		case 3: x = document[n]; break;
		default : x = null;
		} 
	return x; 
} 

// Function to return browser type.
// Returns: 1=IE, 2=NS6, 3=NS4, null=unknown.
function getBrowser() { 
	var x; 
	var ns6 = document.getElementById ? 1 : 0 
	var ie = document.all ? 1 : 0 
	var ns = document.layers ? 1 : 0 
	if(ns6){x = 2; } 
	else if(ie){x = 1; } 
	else if(ns){x = 3; } 
	return x; 
} 

// Function to return IE version.
// Returns: n, null=unknown.
function getIEVersion() {
	var x = getBrowser();
	if(x == 1 || x == 2)
		{
		var s = Trim(StrTokIdx(navigator.appVersion,";",1));
		s = StrTokIdx(s," ",1);
		return parseInt(s);
		}
	return null; 
} 

// Function to show or hide a table cell.
function ShowHideCell(sTableId,nRow,nCell,Show) 
	{ 
	var oTable = getObj(sTableId);
	if(oTable)
		{
		var oCollR = oTable.rows;
		if(oCollR.length > 0 && nRow < oCollR.length)
			{
			if(nRow < 0)
				nRow = oCollR.length - 1;	//last
			var oRow = oCollR[nRow];
			var oCollC = oRow.cells;
			if(oCollC.length > 0 && nCell < oCollC.length)
				{
				if(nCell < 0)
					nCell = oCollC.length - 1;	//last
				var oCell= oCollC[nCell];
				if(Show==null)
					{
					if(oCell.style.display == "none")
						oCell.style.display = "inline";
					else
						oCell.style.display = "none";
					}
				else
					oCell.style.display = (Show) ? "inline" : "none";
				}
			}
		}
	}
